---
type: SYSTEM_MODULE
title: Report Build Standardization (Research Output Post-Processing)
version: 0.2
date: 2025-12-19
extends: SYSTEM_Titan_AI_Research_Engine_v2
purpose: |
  Defines the standard post-processing workflow for converting Titan Research 
  Engine outputs into standardized, transportable research reports. Eliminates 
  manual prompting for file naming, citation formatting, and supplemental 
  navigation sections.
  
  v0.2 adds: Brief lifecycle management (status updates post-research), 
  associated_brief field in report YAML for bidirectional linking.
usage: |
  When Titan Research completes, Claude should proactively ask: "Ready to build 
  standardized report?" If yes, execute this module without further prompting. 
  The goal is zero-friction conversion from raw research to professional deliverable.
changelog: |
  v0.2 (2025-12-19): Added Phase 4 (Brief Status Update), associated_brief field 
  in report YAML, brief lifecycle management protocol
tags: [titan-research, report-build, standardization, post-processing, deliverables, brief-lifecycle]
---

# Report Build Standardization Module v0.2

## System Philosophy

**Raw research outputs are not deliverables.** They're artifacts of the research process. Deliverables require:
- Professional naming conventions
- Citation architecture for reference tracking
- Navigation aids for decision-making post-research
- Quality assessment against original brief
- **Lifecycle linkage** (brief ↔ report bidirectional tracking)

**This module automates the conversion** from research artifact → standardized report, eliminating repetitive manual prompting.

---

## When This Module Activates

**Trigger conditions**:
1. Titan Research Engine completes output
2. User indicates research is complete/satisfactory
3. User explicitly requests "report build" or "standardize this"

**Proactive prompt**: "Ready to build standardized report?" (if context suggests completion)

**Do NOT activate** when:
- Research is clearly mid-iteration (user requesting follow-up searches)
- Output is conversational response, not formal research
- User explicitly requests raw/unformatted output

---

## Core Report Build Process

### **PHASE 1: File Naming Standardization**

**Naming convention**: `RESEARCH_REPORT_topic-in-kebab-case_vX_YYYY-MM-DD.md`

| Component | Rules | Example |
|-----------|-------|---------|
| Prepend | `RESEARCH_REPORT_` (all caps, required) | RESEARCH_REPORT_ |
| Topic | 3-6 words, kebab-case, descriptive | arc-flash-business-texas-market |
| Version | Major versions only (v1, v2, v3) | v1 |
| Date | ISO 8601 (YYYY-MM-DD) | 2025-12-16 |

**Versioning logic**:
- **v1**: Initial research output
- **v2**: Complete re-run of research (not iteration on existing)
- **Decimal versions NOT used** for reports—only for system/module files

**When to increment version**:
- New research run from scratch → increment version
- Supplemental additions/formatting changes → same version, update date

**YAML front matter** (always include):
```yaml
---
type: RESEARCH_REPORT
status: Active
version: X.0
date: YYYY-MM-DD
associated_brief: BRIEF_[topic]_vX_date.md
tags: [keyword1, keyword2, domain]
usage: "One-sentence summary of report purpose and primary decision it informs"
---
```

**🆕 v0.2 Addition:** `associated_brief` field creates bidirectional link (report → brief). This enables:
- Sequential research chaining (Brief N+1 can inherit from Report N)
- Lifecycle tracking (which brief produced which report)
- Context preservation across research sessions

---

### **PHASE 2: Citation Architecture**

**Current state**: Inline citations break when reports are moved/shared. Links become non-functional outside original context.

**Standardized approach**: Numbered references + Sources & Citations section at bottom.

#### **Inline citation format**

Convert from: `<cite>claim text</cite>` or `[Source Name]` 

To: `claim text[X]` where X is numbered reference

**Rules**:
- First citation of source = assign number sequentially
- Subsequent citations of same source = reuse same number
- Multiple sources for one claim = `[X][Y][Z]` (bracket each number)

#### **Sources & Citations section**

**Location**: Second-to-last section in report (only "Research Success Report & Path Navigation" comes after)

**Format**:
```markdown
## Sources & Citations

[1] Source Title (URL)

[2] Source Title (URL)

[3] Source Title (URL)
```

**Anchor linking** (if markdown supports—note for future HTML conversion):
- Source numbers in citation section could become anchor targets
- Inline references become anchor links back to full citation
- *This is noted for future development; not critical for v0.2*

---

### **PHASE 3: Research Success Report & Path Navigation Section**

**Purpose**: The research tool (Titan Engine + Claude) has accumulated context the user needs to re-engage with later. When the user returns to this report days/weeks later (potentially in different chat), they need:
- Quality assessment of research vs. original goals
- Identification of gaps/remaining questions
- Suggested next actions for implementation
- New research directions that emerged

**Location**: Last section before Sources & Citations

**Structure**:

```markdown
## Research Success Report & Path Navigation

**Bottom Line Up Front**: [2-4 sentences synthesizing: Did research achieve stated success criteria? What was the most critical finding? What's the recommended path forward?]

### Remaining Questions & Hypotheses

**From original brief that require deeper investigation**:

1. [Question/hypothesis from original brief that wasn't fully answered, with 1-2 sentences explaining why and what's needed]
2. [Continue for 3-7 items depending on brief complexity]

### Emergent Research Targets

**New questions surfaced through analysis**:

1. [New question/research direction discovered during research that wasn't in original brief, with 1-2 sentences on why it matters]
2. [Continue for 3-7 items]

### Suggested Next Actions

**Critical action path for [goal from brief] (prioritized by leverage)**:

1. **[Action title in bold]** ([cross-reference to relevant section])—[1-3 sentences: What to do, why it's high-leverage, what success looks like]. *[1 sentence on failure mode or caveat if relevant.]*

2. [Continue for 5 actions typically]
```

**Writing guidelines for this section**:
- **Economy of words**: No more than 1 paragraph per item, often just 2-3 sentences
- **Info density**: Every sentence reduces uncertainty or provides decision clarity
- **Cross-references**: Link back to specific sections in report for drill-down
- **Prioritization**: Order by leverage (impact/effort ratio), not importance alone
- **Actionability**: Each item should be implementable without further research

---

### **🆕 PHASE 4: Brief Status Update (Post-Research Lifecycle Management)**

**Purpose**: Close the research loop by updating source brief with completion status and link to report. Enables sequential research chaining.

**Trigger**: Immediately after report standardization complete (after Phase 3).

**Process**:

```
1. Locate associated brief file
   - Check report YAML: associated_brief field
   - If field present → use specified brief
   - If field absent → search for matching brief by topic name
   - If no brief found → log warning, skip update (graceful degradation)

2. Update brief YAML front matter:
   status: Research-Complete
   research_completed: [current date YYYY-MM-DD]
   research_report: [path to report file]
   titan_ready: true (should already be true, but ensure)
   dor_quality_gates_passed: true (should already be true, but ensure)

3. Update brief usage field:
   Append: " [RESEARCH COMPLETE - See report: RESEARCH_REPORT_[topic]_vX_date.md]"

4. Log update in thinking file (if present):
   "Brief status updated: Research-Complete, linked to report"
```

**Example YAML transformation**:

**Before (Brief after research execution):**
```yaml
---
type: BRIEF
status: Titan-Ready
titan_ready: true
dor_quality_gates_passed: true
research_completed: null
research_report: null
version: 1.0
date: 2025-12-19
tags: [arc-flash, business-models]
usage: "Input brief for arc flash business model research"
---
```

**After (Brief after report standardization):**
```yaml
---
type: BRIEF
status: Research-Complete
titan_ready: true
dor_quality_gates_passed: true
research_completed: 2025-12-19
research_report: RESEARCH_REPORT_arc-flash-business-models_v1_2025-12-19.md
version: 1.0
date: 2025-12-19
tags: [arc-flash, business-models]
usage: "Input brief for arc flash business model research [RESEARCH COMPLETE - See report: RESEARCH_REPORT_arc-flash-business-models_v1_2025-12-19.md]"
---
```

**Why This Matters**:
- **Sequential chaining**: Brief N → Report N → Brief N+1 (context inheritance)
- **Lifecycle tracking**: Clear audit trail (which brief produced which report, when)
- **Context preservation**: User can navigate bidirectionally (brief ↔ report)
- **Prevents duplication**: Status shows research already completed on this brief

**Error Handling**:
- If brief file not found → log warning, continue (report still created)
- If brief YAML malformed → log error, continue (report still created)
- If file permissions issue → log error, continue (report still created)
- **Never block report creation** because of brief update issues (graceful degradation)

---

## Quality Gates Before Finalization

**Pre-delivery checklist** (internal validation):

✅ **File naming follows convention** (RESEARCH_REPORT_topic_vX_date.md)  
✅ **YAML front matter complete** with usage field and associated_brief  
✅ **All inline citations converted** to numbered references  
✅ **Sources & Citations section present** with full URLs  
✅ **Research Success section present** with all subsections  
✅ **Content fully retained** (non-destructive conversion—nothing lost from original)  
✅ **Cross-references functional** in Suggested Next Actions  
✅ **🆕 Brief status updated** (if brief exists and accessible)

**If any gate fails → halt and fix before presenting to user**

**Exception for Phase 4**: If brief update fails, log warning but DO NOT block report delivery. Brief update is lifecycle enhancement, not requirement.

---

## Error Prevention & Edge Cases

### **Citation challenges**

**Multiple sources for one claim**: Use consecutive brackets `[1][2][3]`, not comma-separated.

**Source appears in research but no inline citation needed**: Still include in Sources & Citations if it informed findings, even if not directly cited.

**External link in research that's not a source** (e.g., tool recommendation): Leave as inline link, don't move to citations.

### **Content preservation**

**CRITICAL**: This is a formatting/packaging operation, not an editorial operation. 

**Never remove content** during report build unless:
- User explicitly requests removal
- Content is clearly metadata (e.g., "Here are the search results from...")
- Duplicate sections exist (merge, don't delete)

### **Suggested Actions quality**

**Bad action**: "Continue researching X"—too vague  
**Good action**: "Conduct 10 validation interviews with Austin electrical contractors (see GTM Playbook, Month 1)—Test partnership hypothesis; identify 3-5 partners. If lukewarm after 10 conversations, revise channel strategy."

**Why good**: Specific number, cross-reference to relevant section, clear success/failure criteria, actionable immediately.

### **🆕 Brief update edge cases**

**Case 1: Brief in different directory**
- Solution: Use relative path in associated_brief field (e.g., ../other-project/BRIEF_*.md)
- Fallback: If path invalid, search current directory

**Case 2: Multiple briefs for same topic**
- Solution: Use most recent by date
- Better: Report YAML should specify exact brief filename

**Case 3: Brief was external handoff (not created by system)**
- Solution: Update YAML if possible, log warning if YAML missing/malformed
- Fallback: Continue without update (report still valid)

**Case 4: User moves files after research**
- Solution: Paths may break—this is acceptable limitation
- Mitigation: Document in report README that files should stay co-located

---

## Future Development Roadmap (Not Yet Active)

**Noted for v0.3+ and submodule architecture**:

### **Visual/formatting enhancements** (user-requested, not automatic)
- Decision matrices with color-coding (Go/No-Go/Conditional)
- Timeline/Gantt visualizations for GTM playbooks
- Competitive positioning maps (2x2 matrices)
- Financial scenario modeling tables with conditional formatting

### **Submodule candidates**
- `SYSTEM_MOD_report-build-visualizations_v0.1.md`—table styling, charts, diagrams
- `SYSTEM_MOD_report-build-executive-summary_v0.1.md`—standalone 1-page BLUF extracts
- `SYSTEM_MOD_report-build-presentation-mode_v0.1.md`—slide deck conversions

### **Enhancement request protocol**

**When user requests formatting/visual treatment** (e.g., "Make this section a 2x2 matrix" or "Add color-coding to the decision table"):

1. Perform the requested modification
2. **After completion**, state: "This looks like an emergent submodule for the report build process. Want to discuss standardizing [specific enhancement type] for future reports?"
3. Store detailed implementation notes in thinking process
4. If user says yes → draft submodule file; if no → log for future consideration

**Do NOT preemptively suggest enhancements**—only flag when user explicitly requests something that could be standardized.

---

## Integration with Titan Research Engine

### **Titan Phase 4 (Synthesis) → Report Build Module**

When Titan Engine completes Phase 4 synthesis:
1. Output follows Titan's standard schema (BLUF → Decision Matrix → Blind Spots → etc.)
2. User confirms research is complete
3. **Handoff to Report Build Module**: Claude asks "Ready to build standardized report?"
4. If yes → Execute this module (naming, citations, navigation section, brief update)
5. Result: Professional deliverable ready for transport/archival + brief lifecycle closed

### **Brief validation integration**

The "Research Success Report & Path Navigation" section should **explicitly cross-reference back to original brief**:
- Success criteria from brief → Did we achieve them?
- Specific questions from brief → Which remain unanswered?
- Hypotheses from brief → Were they validated/refuted?

**If original brief isn't visible in context** (e.g., research tool ran in separate chat):
- Note in thinking process: "Original brief not in context—cannot validate against success criteria"
- Focus navigation section on emergent insights and actions instead

---

## Version History

- **v0.1** (2025-12-16): Initial module creation. Core functionality: naming convention, citation architecture, navigation section structure. Future visual enhancements noted but not implemented.
- **v0.2** (2025-12-19): Added Phase 4 (Brief Status Update), associated_brief field in report YAML, brief lifecycle management protocol, error handling for brief updates.

---

## Appendix: Quick Reference for Claude

**When research completes**:
1. Ask: "Ready to build standardized report?"
2. If yes → Execute naming, citations, navigation sections, brief update (Phases 1-4)
3. Quality gate check (naming, YAML, citations present, content retained, brief updated)
4. Present standardized report to user
5. If user requests formatting enhancements → perform, then flag for potential submodule

**Never launch report build without**:
- Proper naming (RESEARCH_REPORT_topic_vX_date)
- Sources & Citations section
- Research Success Report & Path Navigation section
- associated_brief field in report YAML
- Brief status update (attempt, gracefully degrade if fails)

**The success metric**: User never has to manually prompt for these standardizations again, and brief-report lifecycle is automatically managed.

---

**END OF SYSTEM MODULE v0.2**
