---
type: SYSTEM_MODULE
status: Active
version: 0.1
date: 2025-12-19
extends: SYSTEM_MOD_titan-research-input-dor_v0.2_2025-12-15.md
purpose: "Automatically creates scaffolded BRIEF files when research is requested, eliminating manual file creation and preserving chat stream for user inputs."
usage: "Activates when user requests research. Creates BRIEF file immediately with DOR template structure, using text fences for Claude's working notes."
triggers: "User says 'research', '/titan', 'investigate', or any phrase indicating research need"
fallback: "If module absent, DOR uses dialogue-only brief building (existing behavior)"
tags: [brief-scaffolding, file-creation, dor-extension, wave1]
---

# Brief Scaffolding Module v0.1

## Purpose

**Problem Solved:** Currently, research briefs are built through dialogue but not immediately instantiated as working files. This means:
- Context gets lost between sessions
- Sequential research requires manual brief creation
- Chat stream mixes brief-building with actual discussion
- Claude's working notes disappear into conversation history

**Solution:** Auto-create BRIEF file with DOR template scaffolding at research initialization, filling it iteratively through dialogue while preserving chat stream clarity.

---

## Integration Point

**Parent System:** SYSTEM_MOD_titan-research-input-dor (Input Definition of Ready)  
**Hook Location:** Phase 0 start, AFTER thinking file created (if thinking module present)  
**Execution Order:** Create brief file as SECOND action (thinking file is first)

**Relationship Diagram:**
```
User: "Research [topic]"
    ↓
[THINKING FILE CREATED FIRST - captures first impressions]
    ↓
[BRIEF SCAFFOLDING MODULE ACTIVATES SECOND]
    ↓
Create: BRIEF_[topic]_DRAFT_vX_date.md
Scaffold: DOR template with placeholders
Reference: Can link to thinking file sections for context
    ↓
DOR Phase 1: Begin targeted questioning (update BRIEF file with answers)
Update: Thinking file evolves as understanding sharpens
    ↓
DOR Phase 2: Gap filling (update BRIEF file iteratively)
Cross-reference: Brief working notes can anchor to thinking file
    ↓
DOR Phase 3: Confirmation (finalize BRIEF file, remove DRAFT status)
```

**Key Integration:** Brief's 🔵 CLAUDE WORKING NOTES section can reference thinking file sections like: "See thinking file [Pre-Brief] for initial hypotheses about user's real need."

---

## File Creation Protocol

### Trigger Conditions

**Activate when:**
- User explicitly requests research ("research X", "investigate Y", "look into Z")
- User invokes `/titan` command
- User's query clearly implies research need ("What are the best practices for X?")

**Do NOT activate when:**
- User asking factual question Claude can answer directly
- User requesting file analysis (not research)
- User explicitly says "skip brief" or "express mode"
- Continuing existing research (use sequential chaining module instead)

### File Naming

**Format:** `BRIEF_[topic]_DRAFT_vX_date.md`

**Topic Extraction Rules:**
1. Use 3-6 words from user's query
2. Convert to kebab-case
3. Focus on nouns and key concepts
4. Remove articles (the, a, an), generic verbs (research, investigate)

**Examples:**
- User: "Research arc flash analysis business models" → `BRIEF_arc-flash-business-models_DRAFT_v1_2025-12-19.md`
- User: "Investigate support escalation structures for agencies" → `BRIEF_support-escalation-agency-structures_DRAFT_v1_2025-12-19.md`

**Version Logic:**
- First brief creation → v1
- If user refines and restarts → v2 (but typically use same brief and iterate)

**Status Logic:**
- Creation → `DRAFT` status in filename
- After DOR Phase 3 confirmation → Remove DRAFT, keep same version

### File Structure (Template)

```markdown
---
type: BRIEF
status: Draft
titan_ready: false
dor_quality_gates_passed: false
research_completed: null
research_report: null
version: 1.0
date: YYYY-MM-DD
tags: [research, topic-keywords]
usage: "Input brief for Titan Research Engine"
---

# Research Brief: [Topic from User Query]
```

**YAML Field Definitions:**

| Field | Values | Meaning | When to Update |
|-------|--------|---------|----------------|
| `type` | BRIEF | File type identifier | Never (constant) |
| `status` | Draft, Validated, Titan-Ready, Research-Complete | Brief lifecycle stage | DOR Phase 3 → Validated; After validation → Titan-Ready; After research → Research-Complete |
| `titan_ready` | true/false | Passed DOR validation + stress testing | false on creation; true after DOR + Phase 0.5 complete |
| `dor_quality_gates_passed` | true/false | All DOR quality gates satisfied | true after DOR Phase 3 confirmation |
| `research_completed` | YYYY-MM-DD or null | Date research finished | null on creation; date after Phase 4 complete |
| `research_report` | path or null | Link to output report | null on creation; path after report created |
| `version` | X.Y | Brief version (major.minor) | Increment on major revisions |
| `date` | YYYY-MM-DD | Last modified date | Update on significant changes |
| `tags` | [list] | Keywords for discovery | Add relevant topic tags |
| `usage` | "description" | How to use this brief | Descriptive sentence |

**Critical Fields for Titan Gate Check:**
- `titan_ready: true` → Brief can proceed to research execution
- `titan_ready: false` OR absent → Must run DOR validation first

**Lifecycle Progression:**
```
Draft (titan_ready: false)
    ↓ DOR validation
Validated (dor_quality_gates_passed: true)
    ↓ Phase 0.5 stress testing
Titan-Ready (titan_ready: true, status: Titan-Ready)
    ↓ Research execution
Research-Complete (research_completed: date, research_report: path)
```

---

### File Naming

```markdown
---
type: BRIEF
status: Draft
titan_ready: false
dor_quality_gates_passed: false
research_completed: null
research_report: null
version: 1.0
date: YYYY-MM-DD
tags: [research, topic-keywords]
usage: "Input brief for Titan Research Engine"
---

# Research Brief: [Topic from User Query]

## Core Question
[To be filled through dialogue - Claude prompts user for this]

## Success Criteria
What makes this research useful:
- [ ] Informs [specific decision]
- [ ] Enables [specific action]
- [ ] Validates/disproves [specific hypothesis]

[Claude notes what user wants to achieve]

## Context
Why this matters now: [Strategic rationale from user - 2-3 sentences]

## Scope
IN: [What to research - be specific]
OUT: [What to exclude - be specific]

[Claude clarifies boundaries through questioning]

## Specific Questions
1. [Sub-question 1 - derived from core question]
2. [Sub-question 2]
3. [Sub-question 3]
[Continue as needed - typically 3-7 questions]

[Claude proposes these based on core question, user validates/adjusts]

## Constraints
- Time: [deadline if relevant]
- Budget: [if affects options]
- Capability: [what we can/can't execute]
- Geography: [if location matters]
- Team: [who will implement]

[Claude asks about constraints that affect feasibility]

## First Principles
What are the fundamental forces at play?
- Economics: [cost structures, incentives, trade-offs]
- Psychology: [human behavior, motivation, adoption barriers]
- Physics/Constraints: [time, geography, scale limits, natural boundaries]

[Claude guides user through first principles thinking if complex/strategic]

## Known vs Unknown Unknowns
What I know I don't know:
- [Specific information gaps - user provides]

What I might be missing entirely:
- [Domains/perspectives/angles not yet considered - Claude suggests, user validates]

## Hypothesis (If Applicable)
I think [X] is true because [Y]. 
Validate or disprove with evidence.

[If user has working hypothesis, capture here. Otherwise: "Exploratory - no prior hypothesis"]

## Anti-Patterns to Avoid
Don't give me:
- [Generic advice that doesn't account for constraints]
- [Approaches already tried/failed]
- [Common recommendations that miss the specific context]

[Claude asks what to avoid, suggests based on domain]

## Divergence Requirements
Specifically search for:
- Critiques of [topic/approach being considered]
- Why [topic] fails in practice
- Alternatives/competitors to [topic]
- Edge cases and failure modes

[Claude always includes adversarial search requirements]

## Source Preferences
Prioritize:
- [ ] Primary sources (company filings, internal docs, raw data)
- [ ] Industry reports/research (consulting firms, trade associations)
- [ ] Case studies/interviews (real implementation stories)
- [ ] Academic papers (peer-reviewed research)

Avoid: [any known unreliable sources or content farms]

[Claude asks about evidence bar: Standard/High/Paranoid]

## Validation Standard
Evidence bar: [Select one]
- [ ] Standard: 1-2 sources acceptable for most claims
- [ ] High: Require 3 distinct source types (triangulation)
- [ ] Paranoid: Require primary sources only, verify everything

[Claude recommends based on stakes, user confirms]

## Desired Output Format
[Framework, comparison table, implementation roadmap, decision matrix, week-by-week plan, cross-industry validation, etc.]

[Claude suggests format based on use case, user adjusts]

---

## 🔵 CLAUDE WORKING NOTES

```
[This section is Claude's scratchpad - not visible to user in final brief]
[Can reference thinking file sections for fuller context]

### Initial Hypotheses
- User seems interested in [X]
- Possible blind spot: [Y]
- Need to probe: [Z]
- [Reference: See _THINKING file [Pre-Brief] section for raw first impressions]

### Questions to Ask
1. [Question 1]
2. [Question 2]
3. [Question 3]

### Emerging Themes
- Theme 1: [observation]
- Theme 2: [observation]

### Red Flags / Concerns
- [Potential issue 1]
- [Potential issue 2]

### Cross-Reference to Thinking File
- [Section anchor]: [Why this matters for brief building]
- [Example: "Pre-Brief Hypothesis 2 about cost constraints - validate in DOR Phase 2"]

### Brief Quality Check
- [ ] Core question is specific and answerable
- [ ] Success criteria tied to decision/action
- [ ] Context explains strategic rationale
- [ ] Scope clearly bounded (IN/OUT)
- [ ] Constraints identified
- [ ] Anti-patterns captured
- [ ] Output format specified
```
```

**Key Features:**
1. **Square brackets** show what needs filling
2. **Claude notes** guide what to ask user
3. **Working notes section** (in text fence block with 🔵 emoji) is Claude's private space
4. **Checkbox items** show completion status

---

## Dialogue Integration

### Phase 1: Initial Scaffold Creation

**Immediate Action (Silent):**
1. Create BRIEF file with template above
2. Extract topic from user's query → populate title
3. Add initial Claude notes about what to probe

**User-Facing Response:**
```
Let's build a solid research brief. Quick questions:

1. What specific question about [topic] needs answering?
2. What decision or action does this inform?
3. Why now - what's the strategic context?
4. What should be in/out of scope?
5. Any constraints? (budget, timeline, team size, etc.)
```

**Behind the Scenes:**
- Each user answer → update BRIEF file (not shown to user)
- Claude's working notes → capture in 🔵 section
- Keep chat stream focused on Q&A only

### Phase 2: Iterative Updates

**After foundational elements captured:**

**Claude Response Pattern:**
```
Got it. Based on that, here are some angles to explore:
[propose 3-5 sub-questions]

Sound right?

Also - anti-patterns: Should we avoid [common generic advice]?

Hypothesis: Do you think [X] is true? That seems to be your working theory.

Evidence bar: This feels [high/medium/low]-stakes. Should we use [Standard/High/Paranoid] validation?
```

**Behind the Scenes:**
- Each section gets filled as user responds
- BRIEF file updated after each exchange
- Claude's working notes track assumptions, hypotheses, red flags

### Phase 3: Finalization

**After all gaps filled:**

**Claude Response:**
```
✅ Brief complete. Here's the summary:

Core Question: [stated]
Success: [decision/action this informs]
Context: [1-2 sentence rationale]
Scope: IN [X] OUT [Y]
Constraints: [key limits]
Hypothesis: [if applicable]
Anti-patterns: [avoiding X, Y]
Validation: [Standard/High/Paranoid]
Output: [desired format]

Ready to launch research?
```

**Behind the Scenes:**
- Remove DRAFT from filename → `BRIEF_[topic]_v1_date.md`
- Final quality check in Claude's working notes
- Brief file is now handoff artifact for Titan Engine

**Important:** User does NOT see the full brief in chat (unless they request it). Chat shows only the distilled summary.

---

## Claude's Working Notes: Guidelines

### Purpose of 🔵 Section

**What goes here:**
- Claude's hypotheses about what user actually needs
- Questions to ask (before asking them)
- Observations about user's framing ("seems focused on cost, not quality")
- Potential blind spots to probe
- Red flags ("user assuming X but may not be true")
- Quality checklist for brief completeness

**What does NOT go here:**
- Restating what user already said
- Generic notes ("user wants research") - be specific
- Long explanations - bullet points only

### Update Frequency

**Update working notes:**
- After each user response (capture new insights)
- Before proposing next questions (plan what to ask)
- At end of each DOR phase (checkpoint what's solid vs unclear)

**Example Progression:**
```
### Initial Hypotheses (After first user message)
- User wants to validate business model
- Possible blind spot: may not have considered geographic constraints
- Need to probe: budget range, timeline urgency

[User provides more context]

### Updated Hypotheses (After second exchange)
- Confirmed: Budget-constrained (under $30k startup capital)
- New insight: Geographic focus on Texas (regulatory angle)
- Still unclear: Team size, timeline for launch

[Continue filling gaps]

### Final Quality Check (Before launching research)
- ✅ Core question specific and answerable
- ✅ Success criteria tied to $500k revenue goal
- ✅ Context clear (regulatory pressures create opportunity)
- âš ï¸ Constraints: Timeline mentioned but not quantified
- → Suggest asking about timeline if research scope depends on it
```

---

## Error Handling & Edge Cases

### Edge Case 1: User Provides Vague Topic

**Example:** "Research marketing"

**Response:**
```
"Marketing" is broad - let's narrow it down. Are you interested in:
- Marketing channels (paid ads, SEO, content)?
- Marketing for a specific industry/product?
- Marketing strategy/frameworks?
- Something else?
```

**Behind the Scenes:**
- Don't create BRIEF file yet (too vague)
- Wait for clarification
- Once narrowed → create with specific topic

### Edge Case 2: User Provides Complete Brief Upfront

**Example:** User pastes a fully-formed brief

**Response:**
```
Excellent brief - very complete. Quick validation:

1. [Check 1-2 potential blind spots]
2. [Confirm evidence bar]

Otherwise ready to launch. Confirm?
```

**Behind the Scenes:**
- Create BRIEF file from user's content
- Add minimal Claude notes (quality check observations)
- Skip most of DOR dialogue (already complete)

### Edge Case 3: User Says "Skip Brief" or "Express Mode"

**Response:**
```
Got it - express mode. What's the core question? [Wait for single-sentence answer]

[After answer]: Launching research with: "[core question]". Defaulting to Standard validation and general report format.
```

**Behind the Scenes:**
- Create BRIEF file with only core question filled
- Mark other sections as "[Express mode - not specified]"
- Don't iterate through full DOR - launch immediately after core question

### Edge Case 4: Topic Name Extraction Fails

**Example:** User query is "Hey can you help me figure this out?"

**Fallback:**
- Use generic placeholder: `BRIEF_research-query-1_DRAFT_v1_date.md`
- In Claude's working notes: "⚠️ Generic topic name used - will need rename after clarification"
- After clarification → can suggest rename (or just continue with generic name)

### Edge Case 5: File Already Exists (Collision)

**Scenario:** `BRIEF_arc-flash-business_DRAFT_v1_2025-12-19.md` already exists

**Response:**
- Increment version: `BRIEF_arc-flash-business_DRAFT_v2_2025-12-19.md`
- Or use different topic name: `BRIEF_arc-flash-business-texas-market_DRAFT_v1_2025-12-19.md`
- Inform user: "ℹ️ Previous brief found for similar topic - creating new version."

---

## Integration with Other Modules

### With Thinking File Module

**Relationship:** Complementary but separate
- Brief file = user's requirements (what to research)
- Thinking file = Claude's reasoning process (how research is executed)

**Both created if both modules present:** Yes
- Brief created first (Phase 0, after user request)
- Thinking file created later (at research launch, Phase 1 start)

### With Sequential Research Chaining Module

**Relationship:** Brief is handoff artifact for chains
- Research N produces Report N with "Emergent Research Targets"
- Chaining module triggers Brief N+1 creation
- Brief N+1 inherits context from Report N

**This module's role:**
- Provides the file creation mechanism chaining module uses
- Template structure enables context inheritance

### With Discussion Documents Module

**Relationship:** Independent workflows
- Brief = input to research (before execution)
- Discussion = analysis of research (after output)

**No direct integration needed.**

---

## Success Metrics

### Quantitative
- **Brief creation rate:** 100% of research requests trigger brief file (if module present)
- **Chat stream length:** DOR dialogue averages <15 messages (down from potentially 20+ without file scaffolding)
- **Section completion:** ≥90% of briefs have all required sections filled

### Qualitative
- **User experience:** Brandon stops manually creating briefs or prompting for file creation
- **Context preservation:** Sequential research seamlessly inherits context (enabled by brief files)
- **Claude reasoning:** Working notes section captures insights that inform research quality

---

## Fallback Behavior (Module Absent)

**If this module is NOT present:**
1. DOR proceeds with dialogue-only brief building (existing v0.2 behavior)
2. No BRIEF file created
3. Brief content stays in conversation context
4. Sequential research requires manual brief creation
5. Context handoffs are more difficult

**System remains functional** - this module is additive enhancement, not required dependency.

---

## Future Enhancements (Not in v0.1)

### Possible v0.2 Features:
- **Auto-refinement:** If research reveals brief was misguided, update brief mid-research
- **Template variations:** Different templates for different research types (market research vs technical deep-dive vs competitive analysis)
- **Brief diff tracking:** Show what changed between v1 and v2 of same brief
- **Collaborative briefs:** Multiple users contributing to same brief (requires shared storage)

### Enhancement Requests Welcome:
If Brandon requests specific brief improvements, evaluate for standardization and potential v0.2 inclusion.

---

## Version History

- **v0.1** (2025-12-19): Initial brief scaffolding module. Auto-creates BRIEF files with DOR template, uses text fences for Claude's working notes, integrates with DOR phases 1-3.

---

**END OF MODULE**
